/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.NetherKnightEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class NetherKnightModel<T extends NetherKnightEntity>
extends AdvancedEntityModel<T>
implements ArmedModel {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public NetherKnightModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.RightArm = this.Body.m_171324_("RightArm");
        this.LeftArm = this.Body.m_171324_("LeftArm");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.defaultHeadMovement(this.Head, 0.0f, 0.0f, headPitch, netHeadYaw);
        this.LeftArm.f_104203_ = 0.0f;
        this.LeftArm.f_104205_ = 0.0f;
        this.RightArm.f_104203_ = 0.0f;
        this.RightArm.f_104205_ = 0.0f;
        this.walking1(this.LeftLeg, limbSwing, limbSwingAmount);
        this.walking2(this.RightLeg, limbSwing, limbSwingAmount);
        this.walking2(this.LeftArm, limbSwing, limbSwingAmount);
        this.walking1(this.RightArm, limbSwing, limbSwingAmount);
        this.setupAttackAnimation(entity, ageInTicks);
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104301_(matrixStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm handSide, PoseStack stack) {
        this.getArm(handSide).m_104299_(stack);
    }

    private ModelPart getArm(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    private void setupAttackAnimation(T entity, float ageInTicks) {
        if (this.f_102608_ > 0.0f) {
            float f = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            float f1 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
            this.LeftArm.f_104205_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104204_ = 0.15707964f;
            this.RightArm.f_104204_ = -0.15707964f;
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                this.RightArm.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.5f;
                this.RightArm.f_104203_ -= f * 1.2f + f1 * 0.4f;
            } else {
                this.LeftArm.f_104203_ = -Mth.m_14089_((float)(ageInTicks * 0.1f)) * 0.5f;
                this.LeftArm.f_104203_ -= f * 1.2f + f1 * 0.4f;
            }
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 53).m_171488_(-6.0f, -3.8f, -2.0f, 12.0f, 7.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(0, 41).m_171488_(-4.5f, 3.0f, -2.0f, 9.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(20, 39).m_171488_(-3.0f, -5.75f, -3.975f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.5f, -5.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition Horn1 = Head.m_171599_("Horn1", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-7.0f, -14.0f, 0.0f, 14.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition Horn2 = Head.m_171599_("Horn2", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-7.0f, -14.0f, 0.0f, 14.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition RightArm = Body.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(48, 46).m_171480_().m_171488_(-2.15f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.25f)).m_171555_(false).m_171514_(48, 11).m_171488_(-2.15f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.5f)).m_171514_(48, 37).m_171480_().m_171488_(-2.15f, 8.9f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-2.0f, (float)0.0f));
        PartDefinition RightShoulder = RightArm.m_171599_("RightShoulder", CubeListBuilder.m_171558_().m_171514_(48, 29).m_171480_().m_171488_(-1.9f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.6f)).m_171555_(false), PartPose.m_171423_((float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition LeftArm = Body.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(48, 46).m_171488_(-1.85f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.25f)).m_171514_(48, 11).m_171488_(-1.85f, -1.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(-0.5f)).m_171514_(48, 37).m_171488_(-1.85f, 8.9f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-2.0f, (float)0.0f));
        PartDefinition LeftShoulder = LeftArm.m_171599_("LeftShoulder", CubeListBuilder.m_171558_().m_171514_(48, 29).m_171488_(-1.6f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)-0.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(32, 47).m_171488_(-2.3f, -2.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.1f)).m_171514_(32, 30).m_171488_(-2.3f, -2.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.2f)).m_171514_(0, 33).m_171488_(-2.3f, 8.9f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)-1.9f, (float)11.0f, (float)0.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(32, 47).m_171480_().m_171488_(-1.7f, -3.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.1f)).m_171555_(false).m_171514_(32, 30).m_171480_().m_171488_(-1.7f, -3.1f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(-0.2f)).m_171555_(false).m_171514_(0, 33).m_171480_().m_171488_(-1.7f, 7.9f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.1f)).m_171555_(false), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

